/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef _BLUETOOTH_H_
#define _BLUETOOTH_H_

/* Host controller/baseband commands */
#define HCI_RESET_CMD            ((0x3 << 10) | 0x0003) /* ocf: 0x03; Opcode: 0x03 */
#define HCI_READ_LOCAL_NAME_CMD  ((0x3 << 10) | 0x0014) /* ocf: 0x03; Opcode: 0x14 */
#define HCI_READ_LOCAL_VER_CMD	 ((0x4 << 10) | 0x0001)

#define COMMAND_COMPLETE_EVENT	(0x0E)



#define HCI_CMD_PKT				0x01
#define HCI_ACL_PKT				0x02
#define HCI_SCO_PKT				0x03
#define HCI_EVENT_PKT			0x04
#define HCI_ERR_PKT     		0x05
#define HCI_NEG_PKT     		0x06

/* hci command packet over uart */
struct hcicmd_pkt {
    unsigned int type;
    unsigned int opcode;
    int len;
    char buf[1024];
};

struct hci_event_pkt_hdr {
    unsigned int eventcode;
    unsigned int plen;
};

int hci_cmd_reset (UART_Handle handle);

/***
 * \brief: routine to get the chip version from the Bluetooth device.
 *
 * \b \Descr: This function sends the set of command to the bluetooth chip
 * \n         to get the chip version.
 *
 * \param: handle [IN]  Bluetooth Uart handler
 * \n      manfid [OUT] pointer to get the version of BT chip
 *
 * \return: SUCCESS This function send success everytime.
 */
SINT32 get_btchip_version
(
	UART_Handle handle,
	UINT32 * manfid
);

/***
 * \brief : Bluetooth gpio initializer routine.
 *
 * \param : VOID
 * \return: SUCCESS
 */

int DM8127_evm_bt_init
(
	void
);

/* Send a HCI command over uart */

/***
 * \brief: HCI command handler.
 *
 * \param: handle [IN] BT UART handler
 * \n      cmd    [IN] future use
 * \n      opcode [IN] opcede to be sent
 * \n      len    [IN] lengthe of the opcode
 *
 * \return: 0 on success
 * \n       1 failed to send
 */

int send_hci_cmd
(
	UART_Handle handle,
	unsigned char cmd,
	unsigned int opcode,
	unsigned char *data,
	int len
);


#endif /*_BLUETOOTH_H_*/
/* END OF FILE */
